package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.permission.APIPermissionDemand;
import cn.blankcat.dto.permission.APIPermissionDemandToCreate;
import cn.blankcat.dto.permission.APIPermissions;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ApiPermissionService{

    // GetAPIPermissions 获取频道可用权限列表
    @GET(Resource.apiPermissionURI)
    Call<APIPermissions> createChannelAnnounces(@Path("guild_id") String guildID);

    // RequireAPIPermissions 创建频道 API 接口权限授权链接
    @POST(Resource.apiPermissionDemandURI)
    Call<APIPermissionDemand> deleteChannelAnnounces(@Path("guild_id") String guildID,
                                                     @Body APIPermissionDemandToCreate demand);



}
