package cn.blankcat.openapi.v1;

import cn.blankcat.openapi.APIVersion;
import cn.blankcat.token.Token;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

import java.util.concurrent.TimeUnit;

public class OpenApi {

    private static final Logger logger = LoggerFactory.getLogger("OpenAPI");
    private static final OpenApiData data = new OpenApiData(null,
            3000,
            APIVersion.APIv1,
            3,
            false,
            false,
            "",
            null);

    public static OpenApiData getData(){
        return data;
    }

    public static Retrofit getClient(Token token, Boolean inSandBox, Integer timeout){
        if (data.getRestyClient() == null){
            return setup(token,inSandBox,timeout);
        }
        return data.getRestyClient();
    }

    public static Retrofit setup(Token token, Boolean inSandBox, Integer timeout){
        if (token == null){
            token = Token.loadFromConfig(null, Token.Type.TYPE_BOT);
        }
        data.setToken(token);
        if (inSandBox != null){
            data.setInSandBox(inSandBox);
        }
        if (timeout != null){
            data.setTimeout(timeout);
        }
        data.setRestyClient(new Retrofit.Builder()
                .baseUrl(Resource.getDomain(data.getInSandBox()))
                .addConverterFactory(JacksonConverterFactory.create())
                .client(new OkHttpClient.Builder()
                        .addInterceptor(chain -> {
                            Request request = chain.request().newBuilder()
                                    .addHeader("Authorization", data.getToken().getRealString())
                                    .build();
                            return chain.proceed(request);
                        })
                        .addInterceptor((chain) -> {
                            Response response = chain.proceed(chain.request());
                            MediaType mediaType = response.body().contentType();
                            String responseString = response.body().string();
                            if (response.code() > 209) {
                                logger.warn("请求错误, 错误内容为:{}", responseString);
                            }
                            return response.newBuilder().body(ResponseBody.create(mediaType, responseString)).build();
                        })
                        .readTimeout(data.getTimeout(), TimeUnit.SECONDS)
                        .writeTimeout(data.getTimeout(), TimeUnit.SECONDS)
                        .connectTimeout(data.getTimeout(), TimeUnit.SECONDS)
                        .build())
                .build());
        return data.getRestyClient();
    }


}
