package cn.blankcat.examples;

import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.pager.GuildPager;
import cn.blankcat.openapi.v1.OpenApi;
import cn.blankcat.openapi.v1.service.MeService;
import cn.blankcat.websocket.v1.WebsocketManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;

import java.io.IOException;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger("main");

    public static void main(String[] args){
        new AtMessageHandler().registry();
        WebsocketManager manager = new WebsocketManager();
        manager.run();
        Retrofit restyClient = OpenApi.getClient(null, false, 3);
        try {
            Guild[] guilds = restyClient.create(MeService.class).meGuilds(GuildPager.defaultPager.QueryParams()).execute().body();
            logger.info("频道ID为-->{}", guilds[0].getId());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

}
