package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// WSPayload websocket 消息结构
public class WSPayload<T>{

    @JsonProperty("op")
    private int opCode;
    @JsonProperty("s")
    private long seq;
    @JsonProperty("t")
    private String type;
    @JsonProperty("d")
    private Object data;
    @JsonProperty("-")
    // 原始的 message 数据
    private byte[] rawMessage;

    public WSPayload(T _data){
        this.data = _data;
    }

    public T getData(){
        return (T)data;
    }

    public WSPayload<T> setData(Object data) {
        this.data = data;
        return this;
    }

    public byte[] getRawMessage() {
        return rawMessage;
    }

    public WSPayload<T> setRawMessage(byte[] rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }
}
