package cn.blankcat.dto.pin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// PinsMessage 精华消息对象
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class PinsMessage {

    // 频道 ID
    @JsonProperty("guild_id")
    private String guildId;
    // 子频道 ID
    @JsonProperty("channel_id")
    private String channelId;
    // 消息 ID 数组
    @JsonProperty("message_ids")
    private String[] messageIds;
}
