package cn.blankcat.dto.permission;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// APIPermissionDemandToCreate 创建频道 API 接口权限授权链接结构体定义
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class APIPermissionDemandToCreate {

    // 子频道 ID
    @JsonProperty("channel_id")
    private String channelId;
    // 权限接口唯一标识
    @JsonProperty("api_identify")
    private APIPermissionDemandIdentify APIIdentify;
    // 接口权限链接中的机器人可使用功能的描述信息
    private String desc;
}
