package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// MessageReactionPager 分页器
public class MessageReactionPager implements Pager{

    // 分页游标
    private String cookie;
    // 分页大小，1-1000，默认是20
    private String limit;

    @Override
    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.cookie)){
            query.put("cookie", this.cookie);
        }
        return query;
    }
    
}
