package cn.blankcat.dto.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// ReactionTarget 表态对象类型
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class ReactionTarget {

    // ReactionTargetType 表情表态对象类型
    public enum ReactionTargetType {
        REACTION_TARGET_TYPE_MSG(0),     // 消息
        REACTION_TARGET_TYPE_FEED(1),    // 帖子
        REACTION_TARGET_TYPE_COMMENT(2), // 评论
        REACTION_TARGET_TYPE_REPLY(3);   // 回复

        private final int value;

        ReactionTargetType(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

    private String id;
    private ReactionTargetType type;
}
