package cn.blankcat.dto.message;

import cn.blankcat.dto.keyboard.MessageKeyboard;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// MessageToCreate 发送消息结构体定义
public class MessageToCreate {

    private String content;
    private Embed embed;
    private Ark ark;
    private String image;
    // 要回复的消息id，为空是主动消息，公域机器人会异步审核，不为空是被动消息，公域机器人会校验语料
    @JsonProperty("msg_id")
    private String msgId;
    @JsonProperty("message_reference")
    private MessageReference messageReference;
    private Markdown markdown;
    private MessageKeyboard keyboard;
    @JsonProperty("event_id")
    private String eventId;
}
