package cn.blankcat.dto.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// MessageAudit 消息审核结构体定义
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class MessageAudit {

    // 审核 ID
    @JsonProperty("audit_id")
    private String auditId;
    // 消息 ID
    @JsonProperty("message_id")
    private String messageId;
    // 频道 ID
    @JsonProperty("guild_id")
    private String guildId;
    // 子频道 ID
    @JsonProperty("channel_id")
    private String channelId;
    // 审核时间
    @JsonProperty("audit_time")
    private String auditTime;
    // 创建时间
    @JsonProperty("create_time")
    private String createTime;
    // 子频道 seq，用于消息间的排序，seq 在同一子频道中按从先到后的顺序递增，不同的子频道之前消息无法排序
    @JsonProperty("seq_in_channel")
    private String seqInChannel;
}
