package cn.blankcat.dto.message;

import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.member.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Message 消息结构体定义
public class Message {

    // 消息ID
    private String id;
    // 子频道ID
    @JsonProperty("channel_id")
    private String channelId;
    // 频道ID
    @JsonProperty("guild_id")
    private String guildId;
    // 内容
    private String content;
    // 发送时间
    private String timestamp;
    // 消息编辑时间
    @JsonProperty("edited_timestamp")
    private String editedTimestamp;
    // 是否@all
    @JsonProperty("mention_everyone")
    private String mentionEveryone;
    // 消息发送方
    private User author;
    // 消息发送方Author的member属性，只是部分属性
    private Member member;
    // 附件
    private MessageAttachment attachments;
    // 结构化消息-embeds
    private Embed[] embeds;
    // 消息中的提醒信息(@)列表
    private User[] mentions;
    // ark 消息
    private Ark ark;
    // 私信消息
    @JsonProperty("direct_message")
    private Boolean directMessage;
    // 子频道 seq，用于消息间的排序，seq 在同一子频道中按从先到后的顺序递增，不同的子频道之前消息无法排序
    @JsonProperty("seq_in_channel")
    private String seqInChannel;
    // 引用的消息
    @JsonProperty("message_reference")
    private MessageReference messageReference;
    // 私信场景下，该字段用来标识从哪个频道发起的私信
    @JsonProperty("src_guild_id")
    private String srcGuildId;
}
