package cn.blankcat.dto.forum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// ForumAuditResult 帖子审核事件主体内容
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class ForumAuditResult {

    @JsonProperty("task_id")
    private String taskId;
    @JsonProperty("guild_id")
    private String guildId;
    @JsonProperty("channel_id")
    private String channelId;
    @JsonProperty("author_id")
    private String authorId;
    @JsonProperty("thread_id")
    private String threadId;
    @JsonProperty("post_id")
    private String postId;
    @JsonProperty("reply_id")
    private String replyId;
    @JsonProperty("type")
    private long publishType;
    private long result;
    @JsonProperty("err_msg")
    private String errMsg;
    @JsonProperty("date_time")
    private String dateTime;

}
