/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.handler;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.WebsocketManager;
import cn.blankcat.websocket.WebsocketService;
import cn.blankcat.websocket.handler.AbstractWebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayLoadHandler
extends AbstractWebsocketHandler<WSPayload> {
    private static final Logger logger = LoggerFactory.getLogger((String)"playLoadHandler");

    @Override
    public void handle(String text) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            WSPayload wsPayload = (WSPayload)mapper.readValue(text, WSPayload.class);
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSInvalidSession.getValue()) {
                logger.info("\u9274\u6743\u5931\u8d25, \u6b63\u5728\u5c1d\u8bd5\u83b7\u53d6\u65b0\u7684session");
                WebsocketManager.setInstance();
                WebsocketService websocketService = new WebsocketService();
                websocketService.checkIdentity(WSEvent.allEventToIntent(), BotConfig.DEFAULT.getNowShard(), BotConfig.DEFAULT.getTotalShard());
            }
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSHeartbeatAck.getValue() && BotConfig.DEFAULT.getDisplayHeart().booleanValue()) {
                logger.info("\u6536\u5230\u5fc3\u8df3\u54cd\u5e94");
            }
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSDispatchEvent.getValue() && WSEvent.WSEventType.TypeResumed.getValue().equals(wsPayload.getType())) {
                logger.info("\u6062\u590d\u8fde\u63a5\u6210\u529f");
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

