/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.handler;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSHelloData;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.handler.AbstractWebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloHandler
extends AbstractWebsocketHandler<WSHelloData> {
    private static final Logger logger = LoggerFactory.getLogger((String)"helloHandler");

    @Override
    public void handle(String text) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            WSPayload wsPayloadHello = (WSPayload)mapper.readValue(text, mapper.getTypeFactory().constructParametricType(WSPayload.class, new Class[]{WSHelloData.class}));
            if (BotConfig.DEFAULT.getLastDelay() != (long)((WSHelloData)wsPayloadHello.getData()).getHeartbeatInterval()) {
                BotConfig.DEFAULT.setLastDelay(((WSHelloData)wsPayloadHello.getData()).getHeartbeatInterval());
            }
            logger.info("\u6536\u5230Hello\u6d88\u606f, \u672c\u6b21delay\u4e3a{}ms", (Object)((WSHelloData)wsPayloadHello.getData()).getHeartbeatInterval());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

