/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.handler;

import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.WebsocketService;
import cn.blankcat.websocket.handler.WebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketHandler<T>
implements WebsocketHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"websocketHandler");
    protected Class<T> clazz;

    public void getActualType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType && ((ParameterizedType)superclass).getRawType().equals(AbstractWebsocketHandler.class)) {
            Type actualTypeArgument = ((ParameterizedType)superclass).getActualTypeArguments()[0];
            this.clazz = (Class)actualTypeArgument;
        }
        if (this.clazz == null) {
            logger.error("{} \u6ca1\u6709\u83b7\u53d6\u5230\u6cdb\u578b\u7c7b\u578b, \u8bf7\u4e3aWebsocketHandler\u6307\u5b9a\u4e00\u4e2a\u6cdb\u578b\u7528\u4e8e\u6d88\u606fData\u7684\u8f6c\u6362", (Object)this.getClass().getName());
        }
    }

    public void register() {
        this.getActualType();
        WebsocketService.CLASS_HANDLER_MAP.get(this.clazz).add(this);
    }

    public T toType(String message) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            WSPayload wsPayload = (WSPayload)mapper.readValue(message, mapper.getTypeFactory().constructParametricType(WSPayload.class, new Class[]{this.clazz}));
            return wsPayload.getData();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public abstract void handle(String var1);
}

