/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.audio.AudioAction;
import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSHelloData;
import cn.blankcat.dto.websocket.WSIdentityData;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSReadyData;
import cn.blankcat.dto.websocket.WSResumeData;
import cn.blankcat.dto.websocket.WebsocketAP;
import cn.blankcat.openapi.GatewayService;
import cn.blankcat.openapi.RetrofitManager;
import cn.blankcat.websocket.WebsocketManager;
import cn.blankcat.websocket.handler.HelloHandler;
import cn.blankcat.websocket.handler.PlayLoadHandler;
import cn.blankcat.websocket.handler.ReadyHandler;
import cn.blankcat.websocket.handler.WebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketService {
    private static final AtomicBoolean HeartBeatFlag = new AtomicBoolean(true);
    private static final ExecutorService fixedThreadPool = Executors.newFixedThreadPool(3);
    private static final Logger logger = LoggerFactory.getLogger((String)"websocketService");
    public static Map<Class<?>, List<WebsocketHandler>> CLASS_HANDLER_MAP = new HashMap();

    public void checkIdentity(int intents, final long nowShard, final long totalShard) {
        ArrayList<Long> shardList = new ArrayList<Long>(){
            {
                this.add(nowShard);
                this.add(totalShard);
            }
        };
        WebSocket webSocket = WebsocketManager.getInstance();
        WSIdentityData wsIdentityData = new WSIdentityData();
        wsIdentityData.setIntents(intents);
        wsIdentityData.setToken(BotConfig.DEFAULT.formatBetterToken());
        wsIdentityData.setShard((List<Long>)shardList);
        WSPayload<WSIdentityData> wsPayload = new WSPayload<WSIdentityData>();
        wsPayload.setOpCode(WSPayload.OPCode.WSIdentity.getValue());
        wsPayload.setData(wsIdentityData);
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString(wsPayload);
            webSocket.send(json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        logger.info("\u6b63\u5728\u83b7\u53d6\u65b0\u7684session");
    }

    private void resume() {
        WSResumeData wsResumeData = new WSResumeData();
        wsResumeData.setToken(BotConfig.DEFAULT.formatBetterToken());
        wsResumeData.setSessionId(BotConfig.DEFAULT.getSessionId());
        wsResumeData.setSeq(BotConfig.DEFAULT.getSeq());
        WSPayload<WSResumeData> wsPayload = new WSPayload<WSResumeData>();
        wsPayload.setOpCode(WSPayload.OPCode.WSResume.getValue());
        wsPayload.setSeq(BotConfig.DEFAULT.getSeq());
        wsPayload.setData(wsResumeData);
        try {
            WebsocketManager.getInstance().send(new ObjectMapper().writeValueAsString(wsPayload));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        logger.info("\u6b63\u5728\u6062\u590d\u8fde\u63a5");
    }

    public void connect() {
        this.connect(WSEvent.allEventToIntent(), BotConfig.DEFAULT.getNowShard(), BotConfig.DEFAULT.getTotalShard());
    }

    public void connect(int intents) {
        this.connect(intents, BotConfig.DEFAULT.getNowShard(), BotConfig.DEFAULT.getTotalShard());
    }

    public void connect(int intents, long nowShard, long totalShard) {
        try {
            WebsocketAP result = (WebsocketAP)((GatewayService)RetrofitManager.getInstance().create(GatewayService.class)).getWebsocketGatewayAP().execute().body();
            if (Objects.requireNonNull(result).getSessionStartLimit().getTotal() == result.getSessionStartLimit().getRemaining() || BotConfig.DEFAULT.getSessionId() == null || BotConfig.DEFAULT.getSessionId().isEmpty()) {
                this.checkIdentity(intents, nowShard, totalShard);
            } else {
                this.resume();
            }
            this.newThreadKeepHeart();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void keepHeart() {
        logger.info("\u542f\u52a8\u5fc3\u8df3\u8fdb\u7a0b\u6210\u529f, \u5f53\u524d\u662f\u5426\u663e\u793a\u5fc3\u8df3\u4fe1\u606f\u4e3a{}(\u65e0\u8bba\u662f\u5426\u663e\u793a\u90fd\u4f1a\u53d1\u9001\u5fc3\u8df3)", (Object)BotConfig.DEFAULT.getDisplayHeart());
        Timer timer = new Timer();
        final ObjectMapper mapper = new ObjectMapper();
        final WebSocket webSocket = WebsocketManager.getInstance();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (HeartBeatFlag.get()) {
                    WSPayload<Long> wsPayload = new WSPayload<Long>();
                    wsPayload.setOpCode(WSPayload.OPCode.WSHeartbeat.getValue());
                    wsPayload.setData(BotConfig.DEFAULT.getSeq());
                    try {
                        webSocket.send(mapper.writeValueAsString(wsPayload));
                        if (BotConfig.DEFAULT.getDisplayHeart().booleanValue()) {
                            logger.info("\u53d1\u9001\u5fc3\u8df3\u6210\u529f");
                        }
                        BotConfig.storeTo(BotConfig.DEFAULT, null);
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 1000L, BotConfig.DEFAULT.getLastDelay() * 4L / 5L);
    }

    private void newThreadKeepHeart() {
        fixedThreadPool.execute(this::keepHeart);
    }

    public void switchHeartFlag() {
        HeartBeatFlag.set(!HeartBeatFlag.get());
    }

    static {
        CLASS_HANDLER_MAP.put(Guild.class, new ArrayList());
        CLASS_HANDLER_MAP.put(Message.class, new ArrayList());
        CLASS_HANDLER_MAP.put(Channel.class, new ArrayList());
        CLASS_HANDLER_MAP.put(Member.class, new ArrayList());
        CLASS_HANDLER_MAP.put(AudioAction.class, new ArrayList());
        CLASS_HANDLER_MAP.put(WSReadyData.class, new ArrayList());
        CLASS_HANDLER_MAP.put(WSHelloData.class, new ArrayList());
        CLASS_HANDLER_MAP.put(WSPayload.class, new ArrayList());
        new ReadyHandler().register();
        new HelloHandler().register();
        new PlayLoadHandler().register();
    }
}

