/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSUrl;
import cn.blankcat.openapi.GatewayService;
import cn.blankcat.openapi.RetrofitManager;
import cn.blankcat.websocket.WebsocketService;
import cn.blankcat.websocket.handler.WebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"websocketManager");

    private WebsocketManager() {
    }

    public static WebSocket getInstance() {
        return Singleton.getInstance();
    }

    public static void setInstance(WebSocket webSocket) {
        Singleton.setInstance(webSocket);
    }

    public static void setInstance() {
        WebsocketManager.setInstance(WebsocketManager.getOkHttpClient().newWebSocket(WebsocketManager.getRequest(), (WebSocketListener)new MyWebSocketListener()));
    }

    private static OkHttpClient getOkHttpClient() {
        return new OkHttpClient.Builder().readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
    }

    private static Request getRequest() {
        String url = "wss://api.sgroup.qq.com/websocket/";
        try {
            WSUrl wsUrl = (WSUrl)((GatewayService)RetrofitManager.getInstance().create(GatewayService.class)).getWebsocketGateway().execute().body();
            url = wsUrl == null ? url : wsUrl.getUrl();
            return new Request.Builder().get().url(url).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Request.Builder().get().url(url).build();
        }
    }

    private static void websocketEventDispatch(String text) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            WSPayload wsPayload = (WSPayload)mapper.readValue(text, WSPayload.class);
            WSEvent.WSEventType wsEventType = WSEvent.WSEventType.ofValue(wsPayload.getType());
            if (wsPayload.getSeq() > 0L) {
                BotConfig.DEFAULT.setSeq(wsPayload.getSeq());
            }
            if (wsEventType == null) {
                if (!(text.contains("heartbeat_interval") || text.contains("\"op\":9") || text.contains("\"op\":11"))) {
                    return;
                }
                wsEventType = WSEvent.WSEventType.ofValue(wsPayload.getOpCode() == WSPayload.OPCode.WSHello.getValue() ? "heartbeat_interval" : (wsPayload.getOpCode() == WSPayload.OPCode.WSInvalidSession.getValue() ? "\"op\":9" : "\"op\":11"));
                if (wsEventType == null) {
                    return;
                }
            }
            Class<?> clazz = WSEvent.eventClassMap.get((Object)wsEventType);
            for (WebsocketHandler websocketHandler : WebsocketService.CLASS_HANDLER_MAP.get(clazz)) {
                websocketHandler.handle(text);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static enum Singleton {
        INSTANCE;

        private WebSocket webSocket = WebsocketManager.getOkHttpClient().newWebSocket(WebsocketManager.getRequest(), (WebSocketListener)new MyWebSocketListener());

        private Singleton() {
            this.webSocket.send("hello");
        }

        public static WebSocket getInstance() {
            return Singleton.INSTANCE.webSocket;
        }

        public static void setInstance(WebSocket webSocket) {
            Singleton.INSTANCE.webSocket = webSocket;
        }
    }

    private static class MyWebSocketListener
    extends WebSocketListener {
        private MyWebSocketListener() {
        }

        public void onOpen(WebSocket webSocket, Response response) {
            super.onOpen(webSocket, response);
        }

        public void onMessage(WebSocket webSocket, String text) {
            WebsocketManager.websocketEventDispatch(text);
            super.onMessage(webSocket, text);
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            super.onMessage(webSocket, bytes);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            super.onClosing(webSocket, code, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            super.onClosed(webSocket, code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
            if (response != null && response.body() != null) {
                MediaType mediaType = response.body().contentType();
                try {
                    String responseString = response.body().string();
                    if (response.code() > 209) {
                        logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
                    }
                    super.onFailure(webSocket, t, response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

