/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.openapi;

import cn.blankcat.config.BotConfig;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RetrofitManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"retrofitManager");

    private RetrofitManager() {
    }

    public static Retrofit getInstance() {
        return Singleton.getInstance();
    }

    public static void setInstance() {
        Singleton.setInstance(new Retrofit.Builder().baseUrl(BotConfig.DEFAULT.getBaseUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(RetrofitManager.getOkHttpClient(BotConfig.DEFAULT.formatBetterToken())).build());
    }

    public static void setInstance(Retrofit retrofit) {
        Singleton.setInstance(retrofit);
    }

    public static void setInstance(String baseUrl, String token) {
        Singleton.setInstance(new Retrofit.Builder().baseUrl(baseUrl).client(RetrofitManager.getOkHttpClient(token)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build());
    }

    private static OkHttpClient getOkHttpClient(String token) {
        return new OkHttpClient.Builder().addInterceptor(chain -> {
            Request request = chain.request().newBuilder().addHeader("Authorization", token).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Response response = chain.proceed(chain.request());
            MediaType mediaType = response.body().contentType();
            String responseString = response.body().string();
            if (response.code() > 209) {
                logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
            }
            return response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build();
        }).readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
    }

    private static enum Singleton {
        INSTANCE;

        private Retrofit retrofit = new Retrofit.Builder().baseUrl(BotConfig.DEFAULT.getBaseUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(RetrofitManager.getOkHttpClient(BotConfig.DEFAULT.formatBetterToken())).build();

        public static Retrofit getInstance() {
            return Singleton.INSTANCE.retrofit;
        }

        public static void setInstance(Retrofit retrofit) {
            Singleton.INSTANCE.retrofit = retrofit;
        }
    }
}

