/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BotConfig {
    public static final BotConfig EMPTY = new BotConfig();
    public static final BotConfig DEFAULT = BotConfig.readFrom(null);
    private String baseUrl = "https://api.sgroup.qq.com";
    private String botId = "";
    private String botToken = "";
    private String botSecret = "";
    private long nowShard = 0L;
    private long totalShard = 1L;
    private long lastDelay = 10000L;
    private Boolean displayHeart = true;
    private long seq = 1L;
    private String sessionId = "";

    public String formatBetterToken() {
        return "Bot " + DEFAULT.getBotId() + "." + DEFAULT.getBotToken();
    }

    public static BotConfig readFrom(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.yaml";
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        InputStream inputStream = BotConfig.class.getClassLoader().getResourceAsStream(filePath);
        mapper.findAndRegisterModules();
        try {
            return (BotConfig)mapper.readValue(inputStream, BotConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    public static void storeTo(BotConfig config, String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.yaml";
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.findAndRegisterModules();
        try {
            URL url = BotConfig.class.getClassLoader().getResource(filePath);
            mapper.writeValue(new File(url.getFile()), (Object)config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBotId() {
        return this.botId;
    }

    public String getBotToken() {
        return this.botToken;
    }

    public String getBotSecret() {
        return this.botSecret;
    }

    public long getNowShard() {
        return this.nowShard;
    }

    public long getTotalShard() {
        return this.totalShard;
    }

    public long getLastDelay() {
        return this.lastDelay;
    }

    public Boolean getDisplayHeart() {
        return this.displayHeart;
    }

    public long getSeq() {
        return this.seq;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public void setBotToken(String botToken) {
        this.botToken = botToken;
    }

    public void setBotSecret(String botSecret) {
        this.botSecret = botSecret;
    }

    public void setNowShard(long nowShard) {
        this.nowShard = nowShard;
    }

    public void setTotalShard(long totalShard) {
        this.totalShard = totalShard;
    }

    public void setLastDelay(long lastDelay) {
        this.lastDelay = lastDelay;
    }

    public void setDisplayHeart(Boolean displayHeart) {
        this.displayHeart = displayHeart;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotConfig)) {
            return false;
        }
        BotConfig other = (BotConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNowShard() != other.getNowShard()) {
            return false;
        }
        if (this.getTotalShard() != other.getTotalShard()) {
            return false;
        }
        if (this.getLastDelay() != other.getLastDelay()) {
            return false;
        }
        if (this.getSeq() != other.getSeq()) {
            return false;
        }
        Boolean this$displayHeart = this.getDisplayHeart();
        Boolean other$displayHeart = other.getDisplayHeart();
        if (this$displayHeart == null ? other$displayHeart != null : !((Object)this$displayHeart).equals(other$displayHeart)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$botId = this.getBotId();
        String other$botId = other.getBotId();
        if (this$botId == null ? other$botId != null : !this$botId.equals(other$botId)) {
            return false;
        }
        String this$botToken = this.getBotToken();
        String other$botToken = other.getBotToken();
        if (this$botToken == null ? other$botToken != null : !this$botToken.equals(other$botToken)) {
            return false;
        }
        String this$botSecret = this.getBotSecret();
        String other$botSecret = other.getBotSecret();
        if (this$botSecret == null ? other$botSecret != null : !this$botSecret.equals(other$botSecret)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        return !(this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $nowShard = this.getNowShard();
        result = result * 59 + (int)($nowShard >>> 32 ^ $nowShard);
        long $totalShard = this.getTotalShard();
        result = result * 59 + (int)($totalShard >>> 32 ^ $totalShard);
        long $lastDelay = this.getLastDelay();
        result = result * 59 + (int)($lastDelay >>> 32 ^ $lastDelay);
        long $seq = this.getSeq();
        result = result * 59 + (int)($seq >>> 32 ^ $seq);
        Boolean $displayHeart = this.getDisplayHeart();
        result = result * 59 + ($displayHeart == null ? 43 : ((Object)$displayHeart).hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $botId = this.getBotId();
        result = result * 59 + ($botId == null ? 43 : $botId.hashCode());
        String $botToken = this.getBotToken();
        result = result * 59 + ($botToken == null ? 43 : $botToken.hashCode());
        String $botSecret = this.getBotSecret();
        result = result * 59 + ($botSecret == null ? 43 : $botSecret.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        return result;
    }

    public String toString() {
        return "BotConfig(baseUrl=" + this.getBaseUrl() + ", botId=" + this.getBotId() + ", botToken=" + this.getBotToken() + ", botSecret=" + this.getBotSecret() + ", nowShard=" + this.getNowShard() + ", totalShard=" + this.getTotalShard() + ", lastDelay=" + this.getLastDelay() + ", displayHeart=" + this.getDisplayHeart() + ", seq=" + this.getSeq() + ", sessionId=" + this.getSessionId() + ")";
    }

    public BotConfig(String baseUrl, String botId, String botToken, String botSecret, long nowShard, long totalShard, long lastDelay, Boolean displayHeart, long seq, String sessionId) {
        this.baseUrl = baseUrl;
        this.botId = botId;
        this.botToken = botToken;
        this.botSecret = botSecret;
        this.nowShard = nowShard;
        this.totalShard = totalShard;
        this.lastDelay = lastDelay;
        this.displayHeart = displayHeart;
        this.seq = seq;
        this.sessionId = sessionId;
    }

    public BotConfig() {
    }
}

