package cn.blankcat.websocket.handler;

import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.WebsocketService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class WebsocketHandler<T> {

    private static final Logger logger = LoggerFactory.getLogger("websocketHandler");
    protected Class<T> clazz;


    public void getActualType(){
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType
                && ((ParameterizedType) superclass).getRawType().equals(WebsocketHandler.class)) {
            Type actualTypeArgument = ((ParameterizedType) superclass).getActualTypeArguments()[0];
            clazz = (Class<T>) actualTypeArgument;
        }
        if (clazz == null) {
            logger.error("{} 没有获取到泛型类型, 请为WebsocketHandler指定一个泛型用于消息Data的转换", this.getClass().getName());
        }
    }

    /**
     * 根据消息的data类型将该handler注册到websocket服务中
     */
    public void register() {
        getActualType();
        WebsocketService.CLASS_HANDLER_MAP.get(clazz).add(this);
    }

    /**
     * @param message websocket消息
     * @return clazz类型的消息数据
     */
    public T toType(String message) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            WSPayload<T> wsPayload = mapper.readValue(message, mapper.getTypeFactory().constructParametricType(WSPayload.class, clazz));
            return wsPayload.getData();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 实际处理websocket消息的方法
     * @param message websocket消息
     */
    public abstract void handle(String message);
}
