package cn.blankcat.websocket.handler;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSReadyData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadyHandler extends WebsocketHandler<WSReadyData>{

    private static final Logger logger = LoggerFactory.getLogger("readyHandler");

    @Override
    public void handle(String message) {
        try {
            // 发送鉴权后收到ready即为获取到sessionId
            ObjectMapper mapper = new ObjectMapper();
            WSPayload<WSReadyData> wsPayloadReady = mapper.readValue(message, mapper.getTypeFactory().constructParametricType(WSPayload.class, WSReadyData.class));
            BotConfig.DEFAULT.setSessionId(wsPayloadReady.getData().getSessionID());
            BotConfig.storeTo(BotConfig.DEFAULT, null);
            logger.info("新的session获取成功:{}", wsPayloadReady.getData().getSessionID());
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}
