package cn.blankcat.websocket.handler;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.WebsocketManager;
import cn.blankcat.websocket.WebsocketService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayLoadHandler extends WebsocketHandler<WSPayload>{

    private static final Logger logger = LoggerFactory.getLogger("playLoadHandler");

    @Override
    public void handle(String message) {
        try {
             /*
             如果鉴权失败, ws会断开连接, 此时自动创建新的连接并获取新的sessionId
             */
            ObjectMapper mapper = new ObjectMapper();
            WSPayload wsPayload = mapper.readValue(message, WSPayload.class);
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSInvalidSession.getValue()) {
                logger.info("鉴权失败, 正在尝试获取新的session");
                WebsocketManager.setInstance();
                WebsocketService websocketService = new WebsocketService();
                websocketService.checkIdentity(WSEvent.allEventToIntent(), BotConfig.DEFAULT.getNowShard(), BotConfig.DEFAULT.getTotalShard());
            }
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSHeartbeatAck.getValue()
                    && BotConfig.DEFAULT.getDisplayHeart()) {
                logger.info("收到心跳响应");
            }
            if (wsPayload.getOpCode() == WSPayload.OPCode.WSDispatchEvent.getValue() &&
                    WSEvent.WSEventType.TypeResumed.getValue().equals(wsPayload.getType())) {
                logger.info("恢复连接成功");
            }
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}
