package cn.blankcat.websocket.handler;

import cn.blankcat.config.BotConfig;
import cn.blankcat.dto.websocket.WSHelloData;
import cn.blankcat.dto.websocket.WSPayload;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloHandler extends WebsocketHandler<WSHelloData>{

    private static final Logger logger = LoggerFactory.getLogger("helloHandler");
    @Override
    public void handle(String message) {
        try {
            // 发送心跳获取心跳周期
            ObjectMapper mapper = new ObjectMapper();
            WSPayload<WSHelloData> wsPayloadHello = mapper.readValue(message, mapper.getTypeFactory().constructParametricType(WSPayload.class, WSHelloData.class));
            if (BotConfig.DEFAULT.getLastDelay() != wsPayloadHello.getData().getHeartbeatInterval()){
                BotConfig.DEFAULT.setLastDelay(wsPayloadHello.getData().getHeartbeatInterval());
            }
            logger.info("收到Hello消息, 本次delay为{}ms", wsPayloadHello.getData().getHeartbeatInterval());
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }

    }

}
