package cn.blankcat.openapi;

import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.member.User;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Query;

import java.util.List;

public interface UserService {

    @GET("/users/@me")
    Call<User> getUserMe();

    @GET("/users/@me/guilds")
    Call<List<Guild>> getUserMeGuilds(@Query("before") String before,
                                      @Query("after") String after,
                                      @Query("limit") String limit);
}
