package cn.blankcat.openapi;

import cn.blankcat.dto.role.GuildRoles;
import cn.blankcat.dto.role.MemberAddRoleBody;
import cn.blankcat.dto.role.UpdateResult;
import cn.blankcat.dto.role.UpdateRole;
import retrofit2.Call;
import retrofit2.http.*;

public interface RoleService {

    @GET("/guilds/{guild_id}/roles")
    Call<GuildRoles> getGuildRoles(@Path("guild_id") String guildId);

    @POST("/guilds/{guild_id}/roles")
    Call<UpdateResult> postGuildRole(@Path("guild_id") String guildId
            , @Body UpdateRole updateRole);

    @HTTP(method = "PATCH", path = "/guilds/{guild_id}/roles/{role_id}", hasBody = true)
    Call<UpdateResult> patchGuildRole(@Path("guild_id") String guildId
            , @Path("role_id") String roleId
            , @Body UpdateRole updateRole);

    @DELETE("/guilds/{guild_id}/roles/{role_id}")
    Call<String> deleteGuildRole(@Path("guild_id") String guildId
            , @Path("role_id") String roleId);

    @HTTP(method = "PUT", path = "/guilds/{guild_id}/members/{user_id}/roles/{role_id}", hasBody = true)
    Call<String> putGuildRoleUser(@Path("guild_id") String guildId
            , @Path("user_id") String userId
            , @Path("role_id") String roleId
            , @Body MemberAddRoleBody memberAddRoleBody);

    @HTTP(method = "DELETE", path = "/guilds/{guild_id}/members/{user_id}/roles/{role_id}", hasBody = true)
    Call<String> deleteGuildRoleUser(@Path("guild_id") String guildId
            , @Path("user_id") String userId
            , @Path("role_id") String roleId
            , @Body MemberAddRoleBody memberAddRoleBody);
}
