package cn.blankcat.openapi;

import retrofit2.Retrofit;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OpenapiService {

    private static final Map<String, Class<?>> OpenapiServiceMap = new HashMap<>(){{
        put("audio",AudioService.class);
        put("channel",ChannelService.class);
        put("gateway",GatewayService.class);
        put("guild",GuildService.class);
        put("member",MemberService.class);
        put("message",MessageService.class);
        put("role",RoleService.class);
        put("user",UserService.class);
    }};

    /**
     * @param clazz 要创建的Service类, 可以通过OpenapiService.allServiceClass()获取
     * @param <T> Service类型
     * @return Service实例
     */
    public <T> T create(Class<T> clazz) {
        Retrofit retrofit = RetrofitManager.getInstance();
        return retrofit.create(clazz);
    }

    /**
     * @return 返回所有已注册的Service名称
     */
    public Set<String> allServiceName() {
        return OpenapiServiceMap.keySet();
    }

    /**
     * @return 返回有所有已注册的Service类
     */
    public Collection<Class<?>> allServiceClass(){
        return OpenapiServiceMap.values();
    }

    /**
     * 根据Service名称获取Service类
     * @param name Service名称
     * @return 返回Service类
     */
    public Class<?> getServiceClassByName(String name) {
        return OpenapiServiceMap.get(name);
    }

    /**
     * 根据Service名称注册Service类
     * @param name Service名称
     * @param clazz Service类
     */
    public void registerService(String name, Class<?> clazz) {
        OpenapiServiceMap.put(name, clazz);
    }
}
