package cn.blankcat.openapi;

import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageArk;
import cn.blankcat.dto.message.MessageToCreate;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface MessageService {

    @POST("/channels/{channel_id}/messages")
    Call<Message> postChannelMessages(@Path("channel_id") String channelId,
                                      @Body MessageToCreate messageToCreate);

    @POST("/channels/{channel_id}/messages")
    Call<Message> postChannelArkMessages(@Path("channel_id") String channelId,
                                         @Body MessageArk messageArk);

    @GET("/channels/{channel_id}/messages/{message_id}")
    Call<Message> getChannelMessage(@Path("channel_id") String channelId,
                                    @Path("message_id") String messageId);
}
