package cn.blankcat.openapi;

import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.channel.ChannelPermissions;
import cn.blankcat.dto.channel.UpdateChannelPermissions;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.List;

public interface ChannelService {

    @GET("/channels/{channel_id}")
    Call<Channel> getGuildChannel(@Path("channel_id") String channelId);

    @GET("/guilds/{guild_id}/channels")
    Call<List<Channel>> getGuildChannels(@Path("guild_id") String guildId);

    @GET("/channels/{channel_id}/members/{user_id}/permissions")
    Call<ChannelPermissions> getGuildChannelPermissions(@Path("channel_id") String channelId,
                                                        @Path("user_id") String userId);

    @HTTP(method = "PUT", path = "/channels/{channel_id}/members/{user_id}/permissions", hasBody = true)
    Call<String> putGuildChannelPermissions(@Path("channel_id") String channelId,
                                            @Path("user_id") String userId,
                                            @Body UpdateChannelPermissions updateChannelPermissions);
}
