package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// WSReadyData ready，鉴权后返回
public class WSReadyData {

    private int version;
    @JsonProperty("session_id")
    private String sessionID;
    private WSReadyDataUser user;
    private List<Long> shard;
}
