package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// WSPayload websocket 消息结构
public class WSPayload<T> {

    // OPCode 类型
    public enum OPCode{
        WSDispatchEvent(0),
        WSHeartbeat(1),
        WSIdentity(2),
        WSResume(6),
        WSReconnect(7),
        WSInvalidSession(9),
        WSHello(10),
        WSHeartbeatAck(11);
        private final int value;
        OPCode(int value){
            this.value = value;
        }
        @JsonValue
        public int getValue(){
            return value;
        }
    }

    @JsonProperty("op")
    private int opCode;
    @JsonProperty("s")
    private long seq;
    @JsonProperty("t")
    private String type;
    @JsonProperty("d")
    private T data;
}
