package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Session 连接的 session 结构，包括链接的所有必要字段
public class Session {

    // Intent 类型
    public enum Intent{
        IntentGuilds(1),
        IntentGuildMembers(1 << 1),
        IntentGuildBans(1 << 2),
        IntentGuildEmojis(1 << 3),
        IntentGuildIntegrations(1 << 4),
        IntentGuildWebhooks(1 << 5),
        IntentGuildInvites(1 << 6),
        IntentGuildVoiceStates(1 << 7),
        IntentGuildPresences(1 << 8),
        IntentGuildMessages(1 << 9),
        IntentGuildMessageReactions(1 << 10),
        IntentGuildMessageTyping(1 << 11),
        IntentDirectMessages(1 << 12),
        IntentDirectMessageReactions(1 << 13),
        IntentDirectMessageTyping(1 << 14),
        IntentAudio(1 << 29),
        IntentGuildAtMessage(1 << 30);
        private final int value;
        Intent(int value){
            this.value = value;
        }
        @JsonValue
        public int getValue(){
            return value;
        }
    }

    private String id;
    private String url;
    private String token;
    private Intent intent;
    private long lastSeq;
    private ShardConfig shards;

    public String getBetterSession(){
        return "[ws][ID:"+ id +"][Shard:("+ shards.getShardID() + shards.getShardCount() +")][Intent:"+ intent.value +"]";
    }
}
