package cn.blankcat.dto.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// GuildMembersPager 分页器
public class MessagesPager {

    // MessagePagerType 消息翻页拉取方式
    public enum MessagePagerType{
        MPT_AROUND("around"),
        MPT_BEFORE("before"),
        MPT_AFTER("after");
        private final String value;
        MessagePagerType(String value){
            this.value = value;
        }
        @JsonValue
        public String getValue(){
            return value;
        }
    }

    // 拉取类型
    private MessagePagerType type;
    // 消息ID
    private String id;
    // 最大 20
    private String limit;
}
