package cn.blankcat.dto.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// MessageToCreate 发送消息结构体定义
public class MessageToCreate {

    private String content;
    private Embed embed;
    private Ark ark;
    private String image;
    // 要回复的消息id,不为空则认为是被动消息
    @JsonProperty("msg_id")
    private String msgID;
}
