package cn.blankcat.dto.interaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Interaction 互动行为对象
public class Interaction {

    // InteractionType 互动类型
    public enum InteractionType{
        INTERACTION_TYPE_PING(1),
        INTERACTION_TYPE_COMMAND(2);
        private final long value;
        InteractionType(long value){
            this.value = value;
        }
        @JsonValue
        public long getValue(){
            return value;
        }
    }

    // 应用ID
    @JsonProperty("application_id")
    private long applicationID;
    // 互动类型
    private InteractionType type;
    // 互动数据
    private InteractionData data;
    //	版本，默认为 1
    private long version;

}
