package cn.blankcat.dto.dm;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// DirectMessage 私信结构定义，一个 DirectMessage 为两个用户之间的一个私信频道，简写为 DM
public class DirectMessage {

    // 频道ID
    @JsonProperty("guild_id")
    private String guildID;
    // 子频道id
    @JsonProperty("channel_id")
    private String channelID;
    // 私信频道创建的时间戳
    @JsonProperty("create_time")
    private String createTime;
}
