package cn.blankcat.dto.channel;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Channel 频道结构定义
public class Channel{

    // ChannelType 频道类型定义
    public enum ChannelType {
        CHANNEL_TYPE_TEXT(0),
        CHANNEL_TYPE_VOICE(2),
        CHANNEL_TYPE_CATEGORY(4),
        CHANNEL_TYPE_LIVE(10005),           // 直播子频道
        CHANNEL_TYPE_APPLICATION(10006),    // 应用子频道
        CHANNEL_TYPE_BBS(10007);            // 论坛子频道
        private final int value;

        ChannelType(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

    // ChannelSubType 子频道子类型定义
    public enum ChannelSubType {
        CHANNEL_SUBTYPE_CHAT(0),       // 闲聊，默认子类型
        CHANNEL_SUBTYPE_NOTICE(1),     // 公告
        CHANNEL_SUBTYPE_GUIDE(2),      // 攻略
        CHANNEL_SUBTYPE_TEAMGAME(3);   // 开黑
        private final int value;

        ChannelSubType(int value) {
            this.value = value;
            }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

    // 频道ID
    private String id;
    // 群ID
    @JsonProperty("guild_id")
    private String guildId;
    private String permissions;
    // 频道名称
    private String name;
    // 频道类型
    private ChannelType type;
    // 排序位置
    private long position;
    // 父频道的ID
    @JsonProperty("parent_id")
    private String parentID;
    // 拥有者ID
    @JsonProperty("owner_id")
    private String ownerID;
    // 子频道子类型
    @JsonProperty("sub_type")
    private ChannelSubType subType;

}
