package cn.blankcat.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BotConfig {

    public static final BotConfig EMPTY = new BotConfig();
    public static final BotConfig DEFAULT = readFrom(null);

    private String baseUrl;
    private String botId;
    private String botToken;
    private String botSecret;
    private long nowShard = 0L;
    private long totalShard = 1L;
    private long lastDelay = 10000L;
    private Boolean displayHeart = true;
    private long seq = 1L;
    private String sessionId = "";

    public String formatBetterToken(){
        return "Bot "+ BotConfig.DEFAULT.getBotId() + "." + BotConfig.DEFAULT.getBotToken();
    }

    public static BotConfig readFrom(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.yaml";
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        InputStream inputStream = BotConfig.class
                .getClassLoader()
                .getResourceAsStream(filePath);
        mapper.findAndRegisterModules();
        try {
            return mapper.readValue(inputStream, BotConfig.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EMPTY;
    }

    public static void storeTo(BotConfig config, String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.yaml";
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.findAndRegisterModules();
        try {
            URL url = BotConfig.class
                    .getClassLoader()
                    .getResource(filePath);
            mapper.writeValue(new File(url.getFile()), config);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
