/*
 * Decompiled with CFR 0.152.
 */
package com.bjdd.core.mvc.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.CollectionUtils;

public class BeanFilter {
    private static final Logger log = LoggerFactory.getLogger(BeanFilter.class);
    public static SerializeConfig camelCaseConfig = new SerializeConfig();

    public static <T> T filter(Object source, Class<T> t) {
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)source), t);
    }

    public static <T> T filterCamel(Object source, Class<T> t) {
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)source, (SerializeConfig)camelCaseConfig, (SerializerFeature[])new SerializerFeature[0]), t);
    }

    public static <T> List filterList(List list, Class<T> t) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)list), t);
    }

    public static <T> PageImpl<T> filterPage(Page page, Class<T> t) {
        return new PageImpl(JSON.parseArray((String)JSON.toJSONString((Object)page.getContent()), t), page.getPageable(), page.getTotalElements());
    }

    public static <T> List filterCamelList(List list, Class<T> t) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)list, (SerializeConfig)camelCaseConfig, (SerializerFeature[])new SerializerFeature[0]), t);
    }

    public static <T> List filterArray(Object[] array, Class<T> t) {
        if (array.length == 0) {
            return new ArrayList();
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)array), t);
    }

    static {
        BeanFilter.camelCaseConfig.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
    }
}

