/*
 * Decompiled with CFR 0.152.
 */
package com.bjdd.core.mvc.base.querydsl.impl;

import com.google.common.collect.Maps;
import com.querydsl.jpa.BatooTemplates;
import com.querydsl.jpa.DataNucleusTemplates;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import java.util.Map;
import javax.persistence.EntityManager;

public final class JPAProvider {
    private static final Map<Class<?>, JPQLTemplates> mappings = Maps.newHashMap();
    private static final Map<String, JPQLTemplates> templatesByName = Maps.newHashMap();

    private static void addMapping(String className, JPQLTemplates templates) {
        try {
            mappings.put(Class.forName(className), templates);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JPQLTemplates getTemplates(EntityManager em) {
        for (Map.Entry<Class<?>, JPQLTemplates> entry : mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(em.getDelegate().getClass())) continue;
            return entry.getValue();
        }
        for (String key : em.getEntityManagerFactory().getProperties().keySet()) {
            key = key.toLowerCase();
            for (Map.Entry<String, JPQLTemplates> entry : templatesByName.entrySet()) {
                if (!key.contains(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return JPQLTemplates.DEFAULT;
    }

    private JPAProvider() {
    }

    static {
        JPAProvider.addMapping("org.batoo.jpa.core.impl.manager.EntityManagerImpl", (JPQLTemplates)BatooTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.Session", (JPQLTemplates)HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.ejb.HibernateEntityManager", (JPQLTemplates)HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.eclipse.persistence.jpa.JpaEntityManager", (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
        JPAProvider.addMapping("org.apache.openjpa.persistence.OpenJPAEntityManager", (JPQLTemplates)OpenJPATemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.jpa.EntityManagerImpl", (JPQLTemplates)DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManager", (JPQLTemplates)DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManagerImpl", (JPQLTemplates)DataNucleusTemplates.DEFAULT);
        templatesByName.put("batoo", (JPQLTemplates)BatooTemplates.DEFAULT);
        templatesByName.put("eclipselink", (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
        templatesByName.put("hibernate", (JPQLTemplates)HQLTemplates.DEFAULT);
        templatesByName.put("openjpa", (JPQLTemplates)OpenJPATemplates.DEFAULT);
        templatesByName.put("datanucleus", (JPQLTemplates)DataNucleusTemplates.DEFAULT);
    }
}

