/*
 * Decompiled with CFR 0.152.
 */
package com.bjdd.core.mvc.base;

import cn.hutool.core.lang.Assert;
import com.bjdd.core.mvc.annotation.LogicalDelete;
import com.bjdd.core.mvc.base.BaseEntity;
import com.bjdd.core.mvc.base.BaseRepository;
import com.bjdd.core.mvc.base.BaseRepositoryImpl;
import com.bjdd.core.mvc.base.querydsl.impl.JPAQuery;
import com.bjdd.core.mvc.base.querydsl.impl.JPAQueryFactory;
import com.bjdd.core.mvc.base.querydsl.impl.JPAUpdateClause;
import com.bjdd.core.mvc.leaf.IDGen;
import com.bjdd.core.mvc.util.P;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.data.domain.Page;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class BaseService<T extends BaseEntity> {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    protected final String repositoryPrefix = "rp-";
    @PersistenceContext
    protected EntityManager mEntityManager;
    @Autowired
    protected GenericWebApplicationContext context;
    @Autowired
    protected IDGen mIDGen;
    protected JPAQueryFactory queryFactory;
    protected Class<T> tClass;

    @PostConstruct
    public void init() {
        this.queryFactory = new JPAQueryFactory(this.mEntityManager);
    }

    public BaseService(Class<T> tClass) {
        this.tClass = tClass;
    }

    public BaseService() {
        ParameterizedType t = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.tClass = (Class)t.getActualTypeArguments()[0];
    }

    protected BaseRepository getRepository() {
        try {
            return (BaseRepositoryImpl)this.context.getBean("rp-" + this.tClass.getSimpleName());
        }
        catch (NullPointerException e) {
            String className = this.tClass.getSimpleName().split("_")[1];
            return (BaseRepository)this.context.getBean(className.substring(0, 1).toLowerCase() + className.substring(1) + "Repository");
        }
        catch (NoSuchBeanDefinitionException e) {
            return this.repositoryInstance();
        }
    }

    protected BaseRepositoryImpl<T> repositoryInstance() {
        this.context.registerBean("rp-" + this.tClass.getSimpleName(), BaseRepositoryImpl.class, () -> new BaseRepositoryImpl<T>(this.tClass, this.mEntityManager), new BeanDefinitionCustomizer[0]);
        return (BaseRepositoryImpl)this.context.getBean("rp-" + this.tClass.getSimpleName());
    }

    public T findById(Long id) {
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            Optional optional = this.getRepository().findOne((Predicate)this.delPredicate().and((Predicate)this.idPredicate(id)));
            return (T)(optional.isPresent() ? (BaseEntity)optional.get() : null);
        }
        Optional optional = this.getRepository().findById(id);
        return (T)(optional.isPresent() ? (BaseEntity)optional.get() : null);
    }

    public Page<T> findAll(P p, Predicate ... predicates) {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        for (Predicate predicate : predicates) {
            condition = condition.and(predicate);
        }
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
            return this.getRepository().findAll((Predicate)condition, p);
        }
        return this.getRepository().findAll((Predicate)condition, p);
    }

    public List<T> findAll() {
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            return (List)this.getRepository().findAll((Predicate)this.delPredicate());
        }
        return this.getRepository().findAll();
    }

    public T save(T t) {
        Assert.notNull(t, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (((BaseEntity)t).getId() == null) {
            ((BaseEntity)t).setId(this.mIDGen.get());
        }
        return (T)((BaseEntity)this.getRepository().save(t));
    }

    public T saveAndFlush(T t) {
        Assert.notNull(t, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (((BaseEntity)t).getId() == null) {
            ((BaseEntity)t).setId(this.mIDGen.get());
        }
        return (T)((BaseEntity)this.getRepository().saveAndFlush(t));
    }

    public List<T> saveAll(List<T> tList) {
        Assert.notNull(tList, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (BaseEntity t : tList) {
            if (t.getId() != null) continue;
            long id = this.mIDGen.get();
            t.setId(id);
        }
        return this.getRepository().saveAll(tList);
    }

    public T edit(Long id, T t) {
        Assert.notNull(this.findById(id), (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (T)((BaseEntity)this.getRepository().save(t));
    }

    public long update(EntityPath entityPath, List<Path<?>> paths, List values, Predicate ... predicates) {
        ArrayList destPaths = new ArrayList(paths);
        ArrayList<Date> destValues = new ArrayList<Date>(values);
        DateTimePath updateTimePath = Expressions.dateTimePath(Date.class, (String)"update_time");
        destPaths.add((Path<?>)updateTimePath);
        destValues.add(new Date());
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            return this.queryFactory.update(entityPath).where(new Predicate[]{this.delPredicate()}).where(predicates).set((List)destPaths, destValues).execute();
        }
        return this.queryFactory.update(entityPath).where(predicates).set((List)destPaths, destValues).execute();
    }

    public JPAUpdateClause update(EntityPath entityPath, Predicate ... predicates) {
        DateTimePath updateTimePath = Expressions.dateTimePath(Date.class, (String)"update_time");
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            return this.queryFactory.update(entityPath).where(new Predicate[]{this.delPredicate()}).where(predicates).set(updateTimePath, new Date());
        }
        return this.queryFactory.update(entityPath).where(predicates).set(updateTimePath, new Date());
    }

    public void _deleteById(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void _deleteInBatch(List<Long> ids) {
        this.getRepository().deleteInBatch(this.getRepository().findAllById(ids));
    }

    public void deleteById(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            T entity = this.findById(id);
            ((BaseEntity)entity).setDelFlag(1);
            this.getRepository().save(entity);
        } else {
            this.getRepository().deleteById(id);
        }
    }

    public long delete(EntityPath entityPath, Predicate ... predicates) {
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            NumberPath delFlagExpression = Expressions.numberPath(Integer.class, (String)"del_flag");
            return this.queryFactory.update(entityPath).where(predicates).set(delFlagExpression, 1).execute();
        }
        return this.queryFactory.delete(entityPath).where(predicates).execute();
    }

    public void deleteInBatch(List<Long> ids) {
        for (Long id : ids) {
            this.deleteById(id);
        }
    }

    public Long getMaxId(EntityPathBase entity) {
        NumberPath idPredicate = Expressions.numberPath(Long.class, (String)"id");
        return (Long)((JPAQuery)((Object)this.queryFactory.select((Expression)idPredicate.max()).from((EntityPath<?>)entity))).fetchOne();
    }

    public Long getAutoId(EntityPathBase entity) {
        Long maxId = this.getMaxId(entity);
        if (maxId == null) {
            maxId = 0L;
        }
        return maxId + 1L;
    }

    public List findAll(Predicate ... predicates) {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        for (Predicate predicate : predicates) {
            condition = condition.and(predicate);
        }
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
        }
        return (List)this.getRepository().findAll((Predicate)condition);
    }

    public Boolean exists(Predicate ... predicates) {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        for (Predicate predicate : predicates) {
            condition = condition.and(predicate);
        }
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
        }
        return this.getRepository().exists((Predicate)condition);
    }

    public T findOne(Predicate ... predicates) {
        Optional optional;
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        for (Predicate predicate : predicates) {
            condition = condition.and(predicate);
        }
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
        }
        return (T)((optional = this.getRepository().findOne((Predicate)condition)).isPresent() ? (BaseEntity)optional.get() : null);
    }

    public Long count(Predicate ... predicates) {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        for (Predicate predicate : predicates) {
            condition = condition.and(predicate);
        }
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
        }
        return this.getRepository().count((Predicate)condition);
    }

    public BooleanExpression delPredicate() {
        NumberPath delFlagPredicate = Expressions.numberPath(Integer.class, (String)"del_flag");
        return delFlagPredicate.eq((Object)0);
    }

    public BooleanExpression delPredicate(Path<T> path) {
        NumberPath delFlagPredicate = Expressions.numberPath(Integer.class, path, (String)"delFlag");
        return delFlagPredicate.eq((Object)0);
    }

    public BooleanExpression idPredicate(Long id) {
        NumberPath idPredicate = Expressions.numberPath(Long.class, (String)"id");
        return idPredicate.eq((Object)id);
    }

    public BooleanExpression getPredicate(Path<T> path) {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate(path));
        }
        return condition;
    }

    public BooleanExpression getPredicate() {
        BooleanExpression condition = Expressions.ONE.eq((Object)1);
        if (this.tClass.getAnnotation(LogicalDelete.class) != null) {
            condition = condition.and((Predicate)this.delPredicate());
        }
        return condition;
    }
}

