package org.bif.test;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.bif.common.utils.JwtUtil;
import org.bif.protocol.bidCredential.BidSelDisclose;

import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class JWSTest {


    public static void main(String[] args) {
        testJWS();
    }

    public static void testJWS() {
        try {
            Map<String, Object> header = new HashMap<>();
            header.put("abc", "123");
            Map<String, Object> payload = new HashMap<>();
            payload.put("p1", "666");
            payload.put("p2", "888");

            Algorithm algorithm = Algorithm.HMAC256("secret");
            String token = JwtUtil.createToken(header, payload, algorithm);
            /*String token = JWT.create()
                    .withHeader(header)
                    .withClaim("name",321)
                    .sign(algorithm);

             */
            //String testPayload = "{\"iss\":\"joe\",\r\n \"exp\":1300819380,\r\n \"http://example.com/is_root\":true}";
            //String retPayload = JWTUtil.formatPayload(testPayload);
            //String orgStr = Base64UrlUtil.base64UrlDecode2String(retPayload);
            //eyJpc3MiOiJqb2UiLA0KICJleHAiOjEzMDA4MTkzODAsDQogImh0dHA6Ly9leGFtcGxlLmNvbS9pc19yb290Ijp0cnVlfQ
            //eyJpc3MiOiJqb2UiLA0KICJleHAiOjEzMDA4MTkzODAsDQogImh0dHA6Ly9leGFtcGxlLmNvbS9pc19yb290Ijp0cnVlfQ==
            System.out.println("token -- " + token);
            //String orgStr = "eyJhbGciOiJIUzI1NiJ9.eyJuYW1lIjp7InN0cmluZyI6InZhbHVlIiwibnVtYmVyIjoxLCJib29sZWFuIjp0cnVlfX0.-8aIaXd2-rp1lLuDEQmCeisCBX9X_zbqdPn2llGxNoc";

            DecodedJWT jwt = JwtUtil.getDecode(token);
            System.out.println("decode -- " + jwt);
            String headerTokenStr = jwt.getHeader();
            String payloadTokenStr = jwt.getPayload();

            System.out.println("headerTokenStr -- " + headerTokenStr);
            System.out.println("payloadTokenStr -- " + payloadTokenStr);

            String payloadStr = new String(Base64.getUrlDecoder().decode(payloadTokenStr), StandardCharsets.UTF_8);
            //System.out.println("payloadStr -- " + payloadStr);
            //Map<String,Object> payloadMap = jwt.getClaim("name").asMap();
            Integer claimInt = jwt.getClaim("name").asInt();
            System.out.println("headerMap -- " + claimInt);


            JWTVerifier verifier = JWT.require(Algorithm.HMAC256("secret")).build();
            DecodedJWT jwtDecode = verifier.verify(token);
            System.out.println("jwtDecode -- " + jwtDecode);
            /*
            JWTVerifier verifier = JWT.require(algorithm)
                    .withIssuer("auth0")
                    .build();
            DecodedJWT jwtDecode = verifier.verify(token);
            System.out.println("jwtDecode -- " + jwtDecode);

             */

            //获取公钥/私钥
            RSA256Key rsa256Key = generateRSA256();
            //根据密钥对生成RS256算法对象 -- 签名
            Algorithm algRsa = Algorithm.RSA256(rsa256Key.getPublicKey(),rsa256Key.getPrivateKey());
            String tokenRsa = JWT.create()
                    .sign(algRsa);

            // -- 验签
            Algorithm algRsa2 = Algorithm.RSA256(rsa256Key.getPublicKey(),null);
            JWTVerifier verifier2 = JWT.require(algRsa2).build();
            DecodedJWT jwtDecode2 = verifier2.verify(tokenRsa);
            System.out.println("jwtDecode2 -- " + jwtDecode2);


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class RSA256Key {

        private RSAPublicKey publicKey;
        private RSAPrivateKey privateKey;

        public RSA256Key() {
        }

        public RSA256Key(RSAPublicKey publicKey, RSAPrivateKey privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public RSAPublicKey getPublicKey() {
            return publicKey;
        }

        public void setPublicKey(RSAPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        public RSAPrivateKey getPrivateKey() {
            return privateKey;
        }

        public void setPrivateKey(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
        }
    }


    public static RSA256Key  generateRSA256(){
        try {
            //第一次校验：单例模式只需要创建一次实例，若存在实例，不需要继续竞争锁，
            RSA256Key rsa256Key = new RSA256Key();
            //RSA256Key单例的双重校验锁

            //第二次校验：防止锁竞争中自旋的线程，拿到系统资源时，重复创建实例

                //密钥生成所需的随机数源
                KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
                keyPairGen.initialize(1024);
                //通过KeyPairGenerator生成密匙对KeyPair
                KeyPair keyPair = keyPairGen.generateKeyPair();
                //获取公钥和私钥
                RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();
                RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();

                rsa256Key.setPublicKey(publicKey);
                rsa256Key.setPrivateKey(privateKey);
                return rsa256Key;

        }catch (Exception e){

        }
        return null;
    }

    public static class PayloadTest{
        private String p1;
        private String p2;

        public String getP1() {
            return p1;
        }

        public void setP1(String p1) {
            this.p1 = p1;
        }

        public String getP2() {
            return p2;
        }

        public void setP2(String p2) {
            this.p2 = p2;
        }
    }
}
