package org.bif.test;

import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.key.PublicKey;
import com.alibaba.fastjson.JSON;
import org.bif.entity.bidAuth.BidAuthChallengeEntity;
import org.bif.entity.bidAuth.BidAuthRequestEntity;
import org.bif.entity.bidAuth.BidAuthResponseEntity;
import org.bif.entity.bidAuth.BidAuthResultEntity;


import org.bif.common.utils.Base64Util;
import org.bif.protocol.enums.AlgorithmEnum;

import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class BidAuthTest {



    public static  void main(String[] args) {
        authTest();
    }

    public static void authTest(){
        try {
            //1.request
            String id = UUID.randomUUID().toString();
            String bid = "did:bid:zfwwYEeDpiNo7f9aXN7uLA3FMbguSTNv";
            String  publicKey = "b07a6604bd0e4d2850cf0b04c3c34f4af37dd6277303ef501cb511851c7e4cb3e08436cc842fff91aeaa539e897f1aadc8a8ebc2c12e3c22a781da4ea51e50cfbc847e40";
            BidAuthRequestEntity requestEntity = new BidAuthRequestEntity(id,bid,publicKey);
            System.out.println("1.-request:" + JSON.toJSONString(requestEntity));

            //2.1 receive-challenge
            String nonce = UUID.randomUUID().toString();
            BidAuthChallengeEntity challengeEntity = new BidAuthChallengeEntity(requestEntity.getId(),nonce);
            System.out.println("2.1-challengeEntity:" + JSON.toJSONString(challengeEntity));

            //2.2 receive-getBid
            String bidPublicKey = "b07a6604bd0e4d2850cf0b04c3c34f4af37dd6277303ef501cb511851c7e4cb3e08436cc842fff91aeaa539e897f1aadc8a8ebc2c12e3c22a781da4ea51e50cfbc847e40";

            //3 request-sign
            String privateKey = "priSrroUh2EVHDsFZAYYXorKRmgm1qjkSxYPwex8EQJrpAwMqU";
            BidAuthChallengeEntity.BidAuthChallengeContent challengeContent = (BidAuthChallengeEntity.BidAuthChallengeContent)challengeEntity.getContent();
            String signText = Base64Util.base64Encode(PrivateKey.sign(challengeContent.getNonce().getBytes(StandardCharsets.UTF_8),privateKey));
            BidAuthResponseEntity responseEntity = new BidAuthResponseEntity(challengeEntity.getId(),
                                                                                challengeContent.getNonce(),
                                                                                bid,
                                                                                bidPublicKey,
                                                                                AlgorithmEnum.SM2.getCode(),
                                                                                signText);
            System.out.println("3-responseEntity:" + JSON.toJSONString(responseEntity));

            //4 receive - result
            //BidAuthResponseContent responseContent = JSON.parseObject(responseEntity.getContent(),BidAuthResponseContent.class);
            BidAuthResponseEntity.BidAuthResponseContent responseContent = (BidAuthResponseEntity.BidAuthResponseContent)responseEntity.getContent();
            boolean bPublicKeyEqual = publicKey.equals(responseContent.getPublicKey());
            System.out.println("4.1-check publickey: " + bPublicKeyEqual);

            boolean bVerifySign  = PublicKey.verify(nonce.getBytes(StandardCharsets.UTF_8),
                    Base64Util.base64Decode(responseContent.getSignText()),
                    publicKey);
            BidAuthResultEntity resultEntity = new BidAuthResultEntity(responseEntity.getId(),bid,bVerifySign);
            System.out.println("4.2-BidAuthResultEntity:" + JSON.toJSONString(resultEntity));



        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
