package org.bif.protocol.enums.bid;

public enum AttributeTypeEnum {
    PERSON_BID(101, "个人数字身份"),
    ENTERPRISE_BID(102, "企业数字身份"),
    NODE_BID(103, "节点数字身份"),
    INTELLIGENT_DEVICE(104, "智能设备"),
    INTELLIGENT_CONTRACT(105, "智能合约"),
    IMAGE(201, "图片"),
    VIDEO(202, "视频"),
    TEXT(203, "文档"),
    RESOURCE(204, "资源数据"),
    CREDENTIAL(205, "凭证"),
    CHAIN_CODE(206, "AC号"),
    UNKNOWN(999, "其它"),
    ;

    private Integer code;
    private String desc;

    private AttributeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
