package org.bif.protocol.bidCredential;


import com.alibaba.fastjson.annotation.JSONField;
import org.bif.protocol.constant.BidCredentialConstants;
import org.bif.protocol.enums.bidCredential.ProcessTypeEnum;


import java.util.ArrayList;
import java.util.List;

//Verifiable Claim（可验证声明）
public class BidVp {
    /**
     {
     "@context":[
        "https://www.w3.org/2018/credentials/v1"
     ],
     "type":[
        "VerifiablePresentation"
     ],
     "credentialRequest":{
        "jws":""
     },
     "credentialParse": [
         {
            "parseType": "...",
            "format" : ""
         }
     ],
     "verifiableCredential   ":[
         {
            "@id":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
         },
         {
            "jws":"…"
         }
     ],
     "proofs": {
        "composeType": "direct",
     }
     }
     */
    // **json-ld**标准格式，必须包含 "https://www.w3.org/2018/credentials/v1".
    @JSONField(name="@context")
    private List<String> context;
    //type: 数组，证书所属类型，必须包含VerifiablePresentation
    private List<String> type;
    //对应的验证请求的jws token
    private CredentialRequest credentialRequest;
    //示各个证书的解析方式,顺序和verifiableCredential里的证书一一对应.
    private List<CredentialParse> credentialParse;
    //可信证书字段，数组，具体证书支持两种格式,对应credentialParse里的format字段
    private List<Object> verifiableCredential;
    //用以提供相关信息辅助从verifiableCredential中的证书推导出需要的可验证声明
    private Proof proofs;

    public BidVp(){
        this.context = new ArrayList<>();
        this.context.add(BidCredentialConstants.CONTEXT);
        this.type = new ArrayList<>();
        this.type.add(ProcessTypeEnum.VP.getType());
    }

    public List<String> getContext() {
        return context;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public CredentialRequest getCredentialRequest() {
        return credentialRequest;
    }

    public void setCredentialRequest(CredentialRequest credentialRequest) {
        this.credentialRequest = credentialRequest;
    }

    public List<CredentialParse> getCredentialParse() {
        return credentialParse;
    }

    public void setCredentialParse(List<CredentialParse> credentialParse) {
        this.credentialParse = credentialParse;
    }

    public List<Object> getVerifiableCredential() {
        return verifiableCredential;
    }

    public void setVerifiableCredential(List<Object> verifiableCredential) {
        this.verifiableCredential = verifiableCredential;
    }

    public Proof getProofs() {
        return proofs;
    }

    public void setProofs(Proof proofs) {
        this.proofs = proofs;
    }

    //   对应的验证请求的jws token
    public static class CredentialRequest {

        private String jws;

        public String getJws() {
            return jws;
        }

        public void setJws(String jws) {
            this.jws = jws;
        }
    }

    //   对应的验证请求的jws token
    public static class CredentialParse {

        private String parseType;
        private String format;

        public String getParseType() {
            return parseType;
        }

        public void setParseType(String parseType) {
            this.parseType = parseType;
        }

        public String getFormat() {
            return format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    //   对应的验证请求的jws token
    public static class Proof {

        private String composeType;

        private String created;

        private Object credentialSubject;

        public String getCreated() {
            return created;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public Object getCredentialSubject() {
            return credentialSubject;
        }

        public void setCredentialSubject(Object credentialSubject) {
            this.credentialSubject = credentialSubject;
        }

        public String getComposeType() {
            return composeType;
        }

        public void setComposeType(String composeType) {
            this.composeType = composeType;
        }
    }
}