package org.bif.protocol.bidComm;

import cn.caict.encryption.utils.hex.HexFormat;
import org.bif.common.utils.Sm4Util;
import org.bif.common.utils.Tools;
import org.bif.exception.BidCommException;
import org.bif.protocol.bidComm.encrypt.EncHeader;
import org.bif.protocol.bidComm.encrypt.EncRecipient;
import org.bif.protocol.enums.AlgorithmEnum;
import org.bif.protocol.enums.bidComm.TypEnum;

import java.util.List;

public class BidCommEncryption extends BidComm{
    /**
     {
     "typ": "bidcomm-encrypted+json",
     "header": {
         "alg": "SM2",
         "enc": "SM4"
     },
     "recipients": [{
         "encrypted_key": "ZIL6Leligq1Xp……KkGgODG",
         "kid": "did:bid:zf27zkk8D72F13HAzY1ECsK12VPUHxKZS#keys-1"
     },
     {
         "encrypted_key": "sOjs0A0typIRSsh…….qPnoJ3iCOr",
         "kid": "did:bid:zf27zkk8D72F13HAzY1ECsK12VPUHxKZS#keys-2"
     }
     ],
     "iv": "X183OV9QdjYtZmc=",
     "ciphertext": "WCufCs2lMZfkxQ0……F_HDR60Jaiw"
     }
     */
    private String typ;
    private EncHeader header;
    //收件人列表
    private List<EncRecipient> recipients;
    //对称加密密文
    private String ciphertext;




    public BidCommEncryption(){
        this.typ = TypEnum.ENCRYPT.getTyp();
        this.header = new EncHeader();

    }

    public String getTyp() {
        return typ;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public EncHeader getHeader() {
        return header;
    }

    public void setHeader(EncHeader header) {
        this.header = header;
    }

    public List<EncRecipient> getRecipients() {
        return recipients;
    }

    public void setRecipients(List<EncRecipient> recipients) {
        this.recipients = recipients;
    }


    public String getCiphertext() {
        return ciphertext;
    }

    public void setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
    }

    public static String generateKey() throws Exception {
        return HexFormat.byteToHex(Sm4Util.generateKey());
    }

    public void buildCiphertext(String key,String signStr ){
        try {
            if (Tools.isNull(this.header) || Tools.isNull(this.header.getEnc())) {
                return ;
            }
            String enc = this.header.getEnc();
            if (enc.equals(AlgorithmEnum.SM4.getCode())) {
                setCiphertext(Sm4Util.encryptEcb(key, signStr));
            }
        }catch (Exception e){
            System.out.println(e.getMessage());
            throw new BidCommException(e.getMessage());
        }
    }


}