package org.bif.protocol.bid.attribute;

import org.bif.protocol.bid.Proof;

import java.util.List;

public class AttributeCredential extends AttributeBase {
    /**
        "issuer": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
        "issuanceDate": "2021-01-20T12:01:20",
        "effectiveDate": "2021-01-20T12:01:20",
        "expirationDate": "2021-04-02T12:01:20",
        "revocationId": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#revocation",
        "credentialSubject": {
            "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
            "type": 202,
            "name": "北京大学",
            "description":""
        },
        "proof": {
            "creator": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1",
            "signatureValue": "eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19"
        }
     */
    private String issuer;
    private String issuanceDate;
    private String effectiveDate;
    private String expirationDate;
    private String revocationId;
    private String templateId;
    private CredentialSubject credentialSubject;
    private List<Proof> proof;

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuanceDate() {
        return issuanceDate;
    }

    public void setIssuanceDate(String issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public String getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getRevocationId() {
        return revocationId;
    }

    public void setRevocationId(String revocationId) {
        this.revocationId = revocationId;
    }

    public CredentialSubject getCredentialSubject() {
        return credentialSubject;
    }

    public void setCredentialSubject(CredentialSubject credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public List<Proof> getProof() {
        return proof;
    }

    public void setProof(List<Proof> proof) {
        this.proof = proof;
    }

    public static class CredentialSubject {
        /**
         "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
         "type": 202,
         "name": "北京大学",
         "description":""
         */
        private String id;
        private String name;
        private String description;
        private Integer type;
        private String content;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }


}