package org.bif.entity.bidCredential;


import com.alibaba.fastjson.annotation.JSONField;
import org.bif.protocol.constant.BidCredentialConstants;
import org.bif.protocol.enums.bidCredential.ProcessTypeEnum;

import java.util.ArrayList;
import java.util.List;

//验证通过证明
public class BidPvEntity {
    /**
     {
     "@context":[
        "https://www.w3.org/2018/credentials/v1"
     ],
     "type":[
        "PresentationVerified"
     ],
     "credentialRequest":{
        "jws":""
     },
     "create":"2010-01-01T19:23:24Z",
     "issuer":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
     }
     */
    // **json-ld**标准格式，必须包含 "https://www.w3.org/2018/credentials/v1".
    @JSONField(name="@context")
    private List<String> context;
    //type: 数组，证书所属类型，必须包含PresentationVerified
    private List<String> type;
    //对应的验证请求的jws token
    private CredentialRequest credentialRequest;
    //签发时间
    private String create;
    //issuer自己的bid
    private String issuer;

    public BidPvEntity(){
        this.context = new ArrayList<>();
        this.context.add(BidCredentialConstants.CONTEXT);
        this.type = new ArrayList<>();
        this.type.add(ProcessTypeEnum.PV.getType());
    }


    public List<String> getContext() {
        return context;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public CredentialRequest getCredentialRequest() {
        return credentialRequest;
    }

    public void setCredentialRequest(CredentialRequest credentialRequest) {
        this.credentialRequest = credentialRequest;
    }

    public String getCreate() {
        return create;
    }

    public void setCreate(String create) {
        this.create = create;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    //   对应的验证请求的jws token
    public static class CredentialRequest {

        private String jws;

        public String getJws() {
            return jws;
        }

        public void setJws(String jws) {
            this.jws = jws;
        }
    }

    //   对应的验证请求的jws token
    public static class CredentialParse {

        private String parseType;
        private String format;

        public String getParseType() {
            return parseType;
        }

        public void setParseType(String parseType) {
            this.parseType = parseType;
        }

        public String getFormat() {
            return format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }


}