package org.bif.entity.bidCredential;


import com.alibaba.fastjson.annotation.JSONField;
import org.bif.protocol.bidCredential.BidVpRequirement;
import org.bif.protocol.constant.BidCredentialConstants;
import org.bif.protocol.enums.bidCredential.ProcessTypeEnum;

import java.util.ArrayList;
import java.util.List;

//   资质验证请求
public class BidCrEntity {
    /*
    * {
        "@context":[
            "https://www.w3.org/2018/credentials/v1"
        ],
        "id":"",
        "type":[
            "credentialRequest"
        ],
        "verifier":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
        "sender":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
        "requirements":{
            "credentials":[
                [
                    {
                        "type":"AlumniCredential",
                        "content":{
                            "alumniOf":{
                                "id":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
                            }
                        },
                        "minVersion":"1.0.2",
                        "maxVersion":"1.9.1",
                        "validBefore":"2010-01-01T19:23:24Z",
                        "issuer":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
                        "subject":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
                    }
                ]
            ],
            "presentation":{
                "composeType":[
                    "direct"
                ]
            }
        }
    }
    * */
    //数组,json-ld规范要求必备字段
    @JSONField(name="@context")
    private List<String> context;
    //id: 验证请求id，在验证方唯一
    private String id;
    //请求类型字段, 数组，必须包含"credentialRequest"
    private List<String> type;
    // 验证方标识，标准地址格式
    private String verifier;
    //消息发送方, 标准地址格式
    private String sender;
    //requirements: 验证条件字段, 说明本次验证需要的证书和声明格式
    private BidCredentialRequirements requirements;

    public BidCrEntity(String id){
        this.context = new ArrayList<>();
        this.context.add(BidCredentialConstants.CONTEXT);
        this.type = new ArrayList<>();
        this.type.add(ProcessTypeEnum.CR.getType());
        this.id = id;
    }

    public BidCrEntity(){
    }

    public List<String> getContext() {
        return context;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public String getVerifier() {
        return verifier;
    }

    public void setVerifier(String verifier) {
        this.verifier = verifier;
    }

    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public BidCredentialRequirements getRequirements() {
        return requirements;
    }

    public void setRequirements(BidCredentialRequirements requirements) {
        this.requirements = requirements;
    }

    //   requirements
    public static class BidCredentialRequirements {

        //credentials: 证书要求字段, 表示需要持有方出示的可信声明里包含的证书, 格式为一个二维数组.
        // 持有方出示声明时, 证书符合第一层数组内任意子数组内的所有证书要求即可
        //当credentials为[[a], [b, c]]时，持有方可以出示[a]或者[b,c]的组合来通过验证。
        private List<List<BidVpRequirement>> credentials;
        //对可信声明部分的要求
        private BidCredentialPresentation presentation;

        public List<List<BidVpRequirement>> getCredentials() {
            return credentials;
        }

        public void setCredentials(List<List<BidVpRequirement>> credentials) {
            this.credentials = credentials;
        }

        public BidCredentialPresentation getPresentation() {
            return presentation;
        }

        public void setPresentation(BidCredentialPresentation presentation) {
            this.presentation = presentation;
        }
    }

    //   presentation
    public static class BidCredentialPresentation {

        //composeType 验证方支持可信证书组装成可信声明的形式
        private List<String> composeType;

        public List<String> getComposeType() {
            return composeType;
        }

        public void setComposeType(List<String> composeType) {
            this.composeType = composeType;
        }
    }


}
