package org.bif.entity.bidComm;


import cn.caict.encryption.utils.sm2.SM2;
import com.alibaba.fastjson.JSONObject;
import org.bif.common.utils.Base64Util;
import org.bif.exception.BidCommException;
import org.bif.protocol.bidComm.BidCommEncryption;
import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.bidComm.encrypt.EncRecipient;
import org.bif.protocol.enums.AlgorithmEnum;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

// Encrypt   ---  E  不可验证私有信息
public class BidCommEEntity extends BidCommEncryption {


    /*
    *BidCommPlaintext   消息明文
    *receiveMap         kid,publicKey形式的接收者id和公钥
    * */
    public BidCommEEntity(BidCommPlaintext bidCommPlaintext,
                          Map<String,String> receiveMap){
        super();
        initBidCommEncryption(bidCommPlaintext,receiveMap);
    }

    public BidCommEEntity(){
        super();
    }



    private void initBidCommEncryption(BidCommPlaintext bidCommPlaintext,Map<String,String> receiveMap){
            initBidCommEncryption(bidCommPlaintext,
                    AlgorithmEnum.SM2.getCode(),
                    AlgorithmEnum.SM4.getCode(),
                    receiveMap);
    }

    private void initBidCommEncryption(BidCommPlaintext bidCommPlaintext,
                                                    String alg,
                                                    String enc,
                                                    Map<String,String> receiveMap) throws BidCommException {
        try {
            this.getHeader().setEnc(enc);
            this.getHeader().setAlg(alg);
            System.out.println("-----initBidCommEncryption  bidCommPlaintext str: " + JSONObject.toJSONString(bidCommPlaintext));
            //16进制密钥
            String key = BidCommEncryption.generateKey();
            System.out.println("-----initBidCommEncryption  key str: " + key);
            //签名数据 对称加密
            this.buildCiphertext(key,JSONObject.toJSONString(bidCommPlaintext));
            System.out.println("-----initBidCommEncryption  Ciphertext str: " + this.getCiphertext());
            List<EncRecipient> recipientsList = new ArrayList<>();
            //kid,publicKey
            Iterator<Map.Entry<String, String>> iter = receiveMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                EncRecipient encRecipient = new EncRecipient();
                /*密钥key进行 SM2公钥加密*/
                byte[] encStr = SM2.encrypt(key.getBytes(StandardCharsets.UTF_8),entry.getValue());
                encRecipient.setEncrypted_key(Base64Util.base64Encode(encStr));
                System.out.println("-----initBidCommEncryption  Encrypted_key str: " + encRecipient.getEncrypted_key());
                encRecipient.setKid(entry.getKey());
                recipientsList.add(encRecipient);
            }
            this.setRecipients(recipientsList);
        }catch (Exception e){
            throw new BidCommException("initBidCommEncryption error");
        }

    }


}
