package org.bif.entity.bidAuth;



import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.enums.bidAuth.AuthTypeEnum;
import org.bif.protocol.enums.bidComm.PlaintextTypeEnum;

//   挑战信息
public class BidAuthResponseEntity extends BidCommPlaintext {


    public BidAuthResponseEntity(String id,
                                 String plainText,
                                 String bid,
                                 String publicKey,
                                 String cryptoType,
                                 String signText){
        super();
        BidAuthResponseContent content = new BidAuthResponseContent(plainText,bid,publicKey,cryptoType,signText);
        this.setType(PlaintextTypeEnum.BIDAUTH.getType());
        this.setId(id);
        this.setContent(content);
    }

    public BidAuthResponseEntity(){
        super();
    }


    //   CONTENT内容
    public static class BidAuthResponseContent {

        private String type;
        private String plainText;
        private String bid;
        private String publicKey;
        private String cryptoType;
        private String signText;

        public BidAuthResponseContent(){

        }

        public BidAuthResponseContent(String plainText,
                                      String bid,
                                      String publicKey,
                                      String cryptoType,
                                      String signText){
            this.type = AuthTypeEnum.RESPONSE.getType();
            this.plainText = plainText;
            this.bid = bid;
            this.publicKey = publicKey;
            this.cryptoType = cryptoType;
            this.signText = signText;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPlainText() {
            return plainText;
        }

        public void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        public String getBid() {
            return bid;
        }

        public void setBid(String bid) {
            this.bid = bid;
        }

        public String getPublicKey() {
            return publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getCryptoType() {
            return cryptoType;
        }

        public void setCryptoType(String cryptoType) {
            this.cryptoType = cryptoType;
        }

        public String getSignText() {
            return signText;
        }

        public void setSignText(String signText) {
            this.signText = signText;
        }
    }


}
